unit PictureTools;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, Menus, ExtCtrls, JPEG,
  GDIPAPI, GDIPOBJ;

type TPictureTools = class(TObject)
private
    //========================
    //  
    fImage           : TImage;
    fImageOK         : boolean;
    //========================
    //  
    fLoadFileName    : string;     //     
    fAutoSize        : boolean;    //  
    fProportional    : boolean;    //   
    //------------------------
    //  
    fPicture         : TPicture;   //   
    fBitMapWidth     : integer;    //   BitMap 
    fBitMapHeight    : integer;    //   BitMap 
    fLoadOK          : boolean;    //  ()  
    //========================
    //  
    fBmp             : TBitMap;
    fGraphics        : TGPGraphics;
    fBmpGD           : TGPBitmap;
    //------------------------
    //  
    fShowFileName    : string;     //     
    fShowWidth       : integer;    // ImgWidth   fProportional
    fShowHeight      : integer;    // ImgWidth   fProportional
    fShowOK          : boolean;    //  ()  
    // ========================
    //      fImage
    procedure CalcImgWH();
    //       GDI+
    function ShowPicture() : boolean;
    //  Jpg -   fPictures.BitMap
    function LoadJpegFromFile(RqFileName : string) : boolean;
public
    //------------------------
    constructor Create(RqImage : TImage);
    procedure Free();
    //------------------------
    //  JPEG      Image 
    function JpegToImage(RqFileName : string) : boolean;
    //     
    procedure ImageClear();
    //------------------------
    // property   
    property BitMapWidth   : integer read fBitMapWidth;
    property BitMapHeight  : integer read fBitMapHeight;
    property LoadFileName  : string read fLoadFileName;
    property LoadOK        : boolean read fLoadOK;
    //------------------------
    // property    
    property AutoSize      : boolean read fAutoSize     write fAutoSize;
    property Proportional  : boolean read fProportional write fProportional;
    //------------------------
    // property   
    property ShowWidth     : integer read fShowWidth;
    property ShowHeight    : integer read fShowHeight;
    property ShowFileName  : string read fShowFileName;
    property ShowOK        : boolean read fShowOK;
end;

implementation

// -------------------------------------------------------------------------
// 26.10.2016
constructor TPictureTools.Create(RqImage : TImage);
begin
    inherited Create;
    fImage   := RqImage;
    fImageOK := False;
    if Assigned(fImage) then fImageOK := True;
    fAutoSize     := True;
    fProportional := True;
    fPicture  := TPicture.Create;
    fBmp      := TBitMap.Create;
end;
// -------------------------------------------------------------------------
// 26.10.2016
procedure TPictureTools.Free();
begin
    fBmp.Free;
    fPicture.Free;
    inherited Free;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//      fImage
procedure TPictureTools.CalcImgWH();
var wPropHW : extended;  //    
begin
    //   
    fShowWidth   := fBitMapWidth;
    fShowHeight  := fBitMapHeight;
    if fAutoSize
    then begin
        fShowWidth   := fImage.Width;
        fShowHeight  := fImage.Height;
        if fProportional and (fBitMapHeight > 0)
        then begin
            //    /
            wPropHW := fBitMapWidth / fBitMapHeight;
            //      fImage
            fShowWidth := Round(fImage.Height * wPropHW);
            if ( not(fShowWidth <= fImage.Width))
            //      fImage
            then begin
               if (wPropHW > 0)
               then begin
                  fShowWidth   := fImage.Width;
                  fShowHeight  := Round(fShowWidth / wPropHW);
                end
                else begin
                  fShowWidth   := fImage.Width;
                  fShowHeight  := fImage.Height;
                end;
            end;
        end;
    end;
end;
// -------------------------------------------------------------------------
// 26.10.2016
//      GDI+
function TPictureTools.ShowPicture() : boolean;
begin
  Result  := False;
  fShowOK := False;
  //  
  if not (Assigned(fPicture) and fLoadOK and Assigned(fImage)) then Exit;
  //    fPicture  fBmp
  fBmp.Assign(TBitmap(fPicture.Graphic));
  // ------------------
  //  fBmpGD   GDI+
  fBmpGD := TGPBitmap.Create(fBmp.Handle, fBmp.Palette);
  // ------------------
  //      
  CalcImgWH();
  // ------------------
  //  fImage    
  fImage.Visible := False;
  //  fImage  fGraphics
  fImage.Picture.Bitmap.Width  := fShowWidth;
  fImage.Picture.Bitmap.Height := fShowHeight;
  fImage.Width  := fShowWidth;
  fImage.Height := fShowHeight;
  //  fImage    ( )
  fImage.Canvas.Brush.Color := fImage.Parent.Brush.Color;
  fImage.Canvas.FillRect(Rect(0, 0, fImage.Width, fImage.Height));
  // ------------------
  //   1
  if fBmpGD.GetLastStatus <> Ok
  then begin
       //   GDI+
       if Assigned(fBmpGD) then fBmpGD.Free;
       MessageDlg('GDI+    TGPBitmap.Create :'
                  +  #13#10 + fLoadFileName,
                  mtError, [mbOk], 0);
  end
  else begin
     //  
     //    fGraphics (GDI+)  fImage
     fGraphics := TGPGraphics.Create(fImage.Picture.Bitmap.Canvas.Handle);
     if fGraphics.GetLastStatus <> Ok
     then begin
          //   GDI+
          if Assigned(fBmpGD) then fBmpGD.Free;
          if Assigned(fGraphics) then fGraphics.Free;
          MessageDlg('GDI+    TGPGraphics.Create :'
                     +  #13#10 + fLoadFileName,
                      mtError, [mbOk], 0);
     end
     else begin
        //  
        //      
        fGraphics.SetInterpolationMode(InterpolationModeDefault);
        // ------------------
        //  
        fGraphics.DrawImage(fBmpGD, 0,0, fShowWidth, fShowHeight);
        // ------------------
        //   GDI+
        if Assigned(fBmpGD)
        then fBmpGD.Free;
        if Assigned(fGraphics)
        then fGraphics.Free;
        // ------------------
        //    
        fShowFileName := fLoadFileName;
        fShowOK := True;
        Result  := True;
     end;
   end;
   //   fImage
   fImage.Visible := True;
end;

// -------------------------------------------------------------------------
// 28.10.2016
//     
procedure TPictureTools.ImageClear();
begin
  if not Assigned(fImage) then Exit;
  //  fImage    ( )
  fImage.Canvas.Brush.Color := fImage.Parent.Brush.Color;
  fImage.Canvas.FillRect(Rect(0, 0, fImage.Width, fImage.Height));
end;

// -------------------------------------------------------------------------
// 26.10.2016
//  Jpg -   fPictures.BitMap
function TPictureTools.LoadJpegFromFile(RqFileName : string) : boolean;
begin
  Result   := False;
  fLoadOK  := False;  //  ()   
  //  
  if not ((RqFileName <> '') and
           Assigned(fImage)  and
           Assigned(fPicture)) then Exit;
  // --------------------
  //       ,
  //     
  if UpperCase(RqFileName) = UpperCase(fShowFileName)
  then begin
     fLoadOK  := True;  //  ()  
     Result   := True;
     Exit;
  end;
  // --------------------
  //    
  try
    //  WPicture 
    fPicture.LoadFromFile(RqFileName);
    if fPicture.Graphic is TJpegImage
    then begin
        //  JPG  BitMap
        TJpegImage(fPicture.Graphic).DIBNeeded;
        //      BitMap 
        fBitMapWidth   := TBitmap(fPicture.Graphic).Width;
        fBitMapHeight  := TBitmap(fPicture.Graphic).Height;
        fLoadFileName  := RqFileName;
        fLoadOK := True;  //  ()  
        Result := True;
     end;
   except
      fLoadFileName  := '';
      fLoadOK := False;
      Result := False;
   end;
end;

// -------------------------------------------------------------------------
// 26.10.2016
//  JPEG      Image 
function TPictureTools.JpegToImage(RqFileName : string) : boolean;
begin
    Result := False;
    if LoadJpegFromFile (RqFileName)
    then Result := ShowPicture();
end;

// =========================================================================
// 
// =========================================================================


end.
